// Imports
const { mergeRules } = require('./util/helpers')

const semver = require('semver')

module.exports = (api, options) => {
  const dependencies = api.service.pkg.dependencies || {}
  const devDependencies = api.service.pkg.devDependencies || {}

  const hasVuetifyLoader = !!(
    devDependencies['vuetify-loader'] ||
    dependencies['vuetify-loader']
  )

  const hasVuetifyPlugin = !!(
    devDependencies['webpack-plugin-vuetify'] ||
    dependencies['webpack-plugin-vuetify']
  )

  const isVue3 = semver.major(require('vue/package.json').version) === 3

  if (isVue3) {
    if (hasVuetifyPlugin) {
      const { VuetifyPlugin } = require('webpack-plugin-vuetify')

      api.chainWebpack(config => {
        config
          .plugin('VuetifyPlugin')
          .use(VuetifyPlugin, [options.pluginOptions.vuetify])
      })
    } else if (hasVuetifyLoader) {
      throw new Error('vuetify-loader is only for use with vuetify 2, replace it with webpack-plugin-vuetify')
    }
  } else if (hasVuetifyLoader) {
    const VuetifyLoaderPlugin = require('vuetify-loader/lib/plugin')

    api.chainWebpack(config => {
      config
        .plugin('VuetifyLoaderPlugin')
        .use(VuetifyLoaderPlugin)
    })
  }

  // Resolve asset references from components
  api.chainWebpack(config => {
    config.module
      .rule('vue')
      .use('vue-loader')
      .tap(options => {
        const transformAssetUrls = options.transformAssetUrls || {}

        return ({
          ...options,
          transformAssetUrls: {
            // v-app-bar extends v-toolbar
            'v-app-bar': 'src',
            // v-carousel-item extends v-img
            'v-carousel-item': ['src', 'lazy-src'],
            'v-img': ['src', 'lazy-src'],
            'v-navigation-drawer': 'src',
            'v-parallax': 'src',
            'v-toolbar': 'src',
            ...transformAssetUrls,
          },
        })
      })
  })

  // Avoid loading styles in testing
  if (process.env.NODE_ENV === 'test') {
    api.chainWebpack(config => {
      const sassRule = config.module.rule('sass')
      sassRule.uses.clear()
      sassRule.use('null-loader').loader(require.resolve('null-loader'))

      const scssRule = config.module.rule('scss')
      scssRule.uses.clear()
      scssRule.use('null-loader').loader(require.resolve('null-loader'))
    })

    return
  }

  // Bootstrap SASS Variables
  if (!isVue3) {
    api.chainWebpack(config => {
      ['vue-modules', 'vue', 'normal-modules', 'normal'].forEach(match => {
        for (let i = 0; i < 2; i++) {
          const boolean = Boolean(i)
          const rule = boolean ? 'sass' : 'scss'

          config.module
            .rule(rule)
            .oneOf(match)
            .use('sass-loader')
            .tap(opt => mergeRules(api, opt, rule))
        }
      })
    })
  }
}
