import { createVNode as _createVNode } from "vue";
// Styles
import "./VDatePickerControls.css";

// Components
import { VBtn } from "../../components/VBtn/index.mjs";
import { VSpacer } from "../../components/VGrid/index.mjs"; // Composables
import { useDate } from "../date/index.mjs"; // Utilities
import { computed } from 'vue';
import { dateEmits, makeDateProps } from "../VDateInput/composables.mjs";
import { genericComponent, omit, propsFactory, useRender } from "../../util/index.mjs";
export const makeVDatePickerControlsProps = propsFactory({
  nextIcon: {
    type: [String],
    default: '$next'
  },
  prevIcon: {
    type: [String],
    default: '$prev'
  },
  expandIcon: {
    type: [String],
    default: '$expand'
  },
  collapseIcon: {
    type: [String],
    default: '$collapse'
  },
  range: {
    default: false,
    type: [Boolean, String],
    validator: v => v === false || ['start', 'end'].includes(v)
  },
  ...omit(makeDateProps(), ['modelValue', 'inputMode'])
}, 'VDatePickerControls');
export const VDatePickerControls = genericComponent()({
  name: 'VDatePickerControls',
  props: makeVDatePickerControlsProps(),
  emits: {
    ...omit(dateEmits, ['update:modelValue', 'update:inputMode'])
  },
  setup(props, _ref) {
    let {
      emit
    } = _ref;
    const adapter = useDate();
    const monthAndYear = computed(() => {
      const month = props.range === 'end' ? adapter.addMonths(props.displayDate, 1) : props.displayDate;
      return adapter.format(month, 'monthAndYear');
    });
    useRender(() => {
      const prevBtn = _createVNode(VBtn, {
        "variant": "text",
        "icon": props.prevIcon,
        "onClick": () => emit('update:displayDate', adapter.addMonths(props.displayDate, -1))
      }, null);
      const nextBtn = _createVNode(VBtn, {
        "variant": "text",
        "icon": props.nextIcon,
        "onClick": () => emit('update:displayDate', adapter.addMonths(props.displayDate, 1))
      }, null);
      return _createVNode("div", {
        "class": "v-date-picker-controls"
      }, [props.viewMode === 'month' && props.range === 'start' && prevBtn, !!props.range && _createVNode(VSpacer, {
        "key": "range-spacer"
      }, null), _createVNode("div", {
        "class": "v-date-picker-controls__date"
      }, [monthAndYear.value]), _createVNode(VBtn, {
        "key": "expand-btn",
        "variant": "text",
        "icon": props.viewMode === 'month' ? props.expandIcon : props.collapseIcon,
        "onClick": () => emit('update:viewMode', props.viewMode === 'month' ? 'year' : 'month')
      }, null), _createVNode(VSpacer, null, null), props.viewMode === 'month' && !props.range && _createVNode("div", {
        "class": "v-date-picker-controls__month",
        "key": "month-buttons"
      }, [prevBtn, nextBtn]), props.viewMode === 'month' && props.range === 'end' && nextBtn]);
    });
    return {};
  }
});
//# sourceMappingURL=VDatePickerControls.mjs.map