<?php

namespace App\Console\Commands;

use App\Models\ST\Parc\materiel\Materiel_det;
use App\Models\ST\Parc\materiel\Materiel_et;
use App\Services\ApiLogManager;
use App\Services\S3P\S3pApiWrapper;
use Illuminate\Console\Command;
use Illuminate\Support\Carbon;
use Illuminate\Support\Str;

class S3PImportKmsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:s3p';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Importation S3P des Kms.';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->output->title('Starting S3P import');
        $this->output->note("use api_log_token : " . env('API_LOG_TOKEN'));

        $total_imported = 0;
        $started_at = now()->format('Y-m-d H:i:s');
        ob_start();
        $start=microtime(true);

        // Instanciation du wrapper S3pApiWrapper
        $serviceAPI = new S3pApiWrapper();

        // Récupération des ressources à importer
        $datas = $serviceAPI->getRessources();
        $this->output->note("total datas : " . count($datas));

        // Format de données attendu : voir commentaires
        foreach ($datas as $data) {
            // Recherche du matériel étiqueté correspondant au numéro d'immatriculation
            $et = Materiel_et::on('pdl')
                ->where('IMMATRICULATION', trim($data["registration"]))
                ->first();

            if ($et != null && isset($data["mileage_value"])) {
                // Récupération du km_fin_max et de la date_fin_max pour l'étiquette
                $km_fin_max = $et->det->max('KM_FIN');
                $date_fin_max = $et->det->max('FIN');

                if($km_fin_max == null ){
                    $km_fin_max = $data["mileage_value"];
                    $date_fin_max = date('Y-m-d');
                }

                if ($km_fin_max < $data["mileage_value"]) {
                    // Création d'un nouveau matériel détaillé si le km_fin_max est inférieur au km valeur de l'import
                    Materiel_det::on('pdl')
                        ->create([
                            'ID_MATERIEL_DET' => Str::random(32),
                            'IMMAT' => trim($data["registration"]),
                            'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
                            'FIN' => Carbon::parse($data["mileage_ts"])->format('Y-m-d'),
                            'KM_FIN' => $data["mileage_value"],
                            'KM_DEBUT' => $km_fin_max,
                            'SYS_USER_CREATION' => 'IMPORT_S3P',
                            'SYS_USER_MODIFICATION' => 'IMPORT_S3P',
                            'DEBUT' => $date_fin_max,
                        ]);
                    $total_imported++;
                    $this->output->note( trim($data["registration"]) . "km  " . $km_fin_max . " => " . $data["mileage_value"]."km");
                    /* Pour controller si import ok*/
//                    dump([
//                        'ID_MATERIEL_DET' => Str::random(32),
//                        'IMMAT' => trim($data["registration"]),
//                        'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
//                        'FIN' => Carbon::parse($data["mileage_ts"])->format('Y-m-d'),
//                        'KM_FIN' => $data["mileage_value"],
//                        'KM_DEBUT' => $km_fin_max,
//                        'SYS_USER_CREATION' => 'IMPORT_S3P',
//                        'SYS_USER_MODIFICATION' => 'IMPORT_S3P',
//                        'DEBUT' => $date_fin_max,
//                    ]);
                }
            }
        }


        $end=microtime(true);
        $phpinfo=ob_get_contents();
        ob_end_clean();
        $time=$end-$start;

        $finished_at = now()->format('Y-m-d H:i:s');

        if($total_imported != 0){
            $retour = (new ApiLogManager())
                ->log(
                    "import",
                    "S3P",
                    $started_at,
                    $finished_at,
                    $total_imported,
                    $time,
                    [],
                );

            dump($retour);
        } else {
            $this->output->warning("no record updated!");
            $retour = (new ApiLogManager())
                ->log(
                    "warning",
                    "S3P",
                    $started_at,
                    $finished_at,
                    $total_imported, //count($datas),
                    $time,
                    [
                        "tested"=>count($datas),
                        "db"=>"s3p",
                    ],
                );

            dump($retour);

        }

        $this->output->newLine();
        $this->output->success("Import terminé.");
        return Command::SUCCESS;
    }
}
