<?php

namespace App\Console;

use App\Http\Controllers\docs\Doc_exports_all;
use App\Http\Controllers\ImportsClients\ImportDispatch;

use App\Http\Controllers\InterfacesApi\OMP\Imports\OmpImportKms;
use App\Http\Controllers\InterfacesApi\S3P\S3pImportKms;
use App\Http\Controllers\InterfacesApi\webfleet\ImportKms;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\DB;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {

        $schedule->command('import:omp')->dailyAt('06:00');
        $schedule->command('import:webfleet')->dailyAt('06:00');
        $schedule->command('import:s3p')->dailyAt('06:10');
        $schedule->command('import:transics')->dailyAt('23:00');

        // Configuration de l'import des fichiers csv pour STS
        $schedule->command('salaries:import-info-from_csv')->dailyAt('12:30');
        $schedule->command('salaries:import-info-from_csv')->dailyAt('23:30');
/*
        php artisan import:omp
        php artisan import:webfleet
        php artisan import:s3p
        php artisan import:transics
*/


        /*
        $importOMP=$schedule->call(function () {
            $exe=new OmpImportKms();
            $exe->OmpImportKmsExe();
            $exe=new OmpImportKms();
            $exe->OmpImportKmsExepjp();
        })->dailyAt('06:00');
        $importOMP->command = 'importOMP';
        $importwebfleet= $schedule->call(function () {
            $exe=new ImportKms();
            $exe->webfleetImportKms();
        })->dailyAt('06:00');
        $imports3p= $schedule->call(function () {
            $exe=new S3pImportKms();
            $exe->s3pImportKms();
        })->dailyAt('06:10');
        $importwebfleet->command = 'importwebfleet';
        $importOMP->command = 'importOMP';
        $imports3p->command = 'imports3p';
        $importtransics= $schedule->call(function () {
            $exe=new ImportDispatch();
            $exe->importDispatchTransics();
        })->dailyAt('23:00');
        $importtransics->command = 'importtransics';
        */

        $maj_test_webfleet_pdl= $schedule->call(function () {
            DB::connection('pdl')->table('materiel_det')->where('IMMAT','GF-272-ZB')->update(['SYS_DATE_MODIFICATION' => date('Y-m-d')]);
            DB::connection('pdl')->table('materiel_det')->where('IMMAT','GF-272-ZC')->update(['SYS_DATE_MODIFICATION' => date('Y-m-d')]);
            DB::connection('pdl')->table('tiers_infos_salaries')->where('NOM_SALARIE','AAAAAAA BBBBBBB')->update(['SYS_DATE_MODIFICATION' => date('Y-m-d')]);
        })->dailyAt('00:01');
        $maj_test_webfleet_pdl->command = 'maj_test_webfleet_pdl';

        // $schedule->call(function () {
        //     Doc_exports_all::index();
        // })->everyMinute();
        // $schedule->call(function () {
        //     $exe=new ExchangeRate();
        //     $exe->getExchangeRate();
        // })->dailyAt('06:00');
    }
    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
