<?php
  
namespace App\Http\Controllers\Boulangerie;

use App\Models\ST\Article;
use App\Models\ST\Commande_abonnement;
use App\Models\ST\Commande_det;
use App\Models\ST\Commande_et;
use DateInterval;
use DatePeriod;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use PhpParser\Node\Expr\Print_;
use SebastianBergmann\CodeUnit\FunctionUnit;

class CommandeController
{
    public function AddCommande(Request  $request, $db)
    {
        $all = $request->all();
        $et = $all['commande'];
        $id = Str::random(32);
        $et['datecomm'] = substr($et['datecomm'], 0, 10);
        if (!isset($et['tel'])) {
            $et['tel'] = '';
        }
        date_default_timezone_set("Europe/Paris");
        $test = Commande_et::on($db)->create(['NOM' => $et['name'], 'ID_COMMANDE_ET' => $id, 'DATE_LIVRAISON' => $et['datecomm'], 'WEB' => 'X', 'EMAIL' => $et['email'], 'POINT_LIVRAISON' => $et['pl'], 'NOTE' => $et['commentaire'], 'CODE_CLIENT' => $et['identifiant'], 'TELEPHONNE' => $et['tel'], 'SYS_DATE_CREATION' => date('YYYY-MM-DD'), 'SYS_HEURE_CREATION' => date('H:i:s')]);
        foreach ($all['articles'] as $articles => $decoupes) {
            foreach ($decoupes as $commDecoupe) {
                if (isset($commDecoupe['Q_COMM'])) {
                    $id_det = Str::random(32);
                    $commDecoupe['DESIGNATION'] = Article::on($db)->where('REFERENCE', $commDecoupe['REFERENCE'])->first()->DESIGNATION;
                    $det = Commande_det::on($db)->create(['CODE_ARTICLE' => $commDecoupe['REFERENCE'], 'PID_COMMANDE_ET' => $id, 'DATE_LIVRAISON' => $et['datecomm'], 'WEB' => 'X', 'ID_COMMANDE_DET' => $id_det, 'Q' => $commDecoupe['Q_COMM'], 'DESIGNATION' => $commDecoupe['DESIGNATION'], 'SYS_HEURE_CREATION' => date('H:i:s')]);
                }
            }
        }
        return ($test);
    }
    public function UpdateCommande(Request  $request, $db)
    {
        $all = $request->all();
        // // $all['nom'];
        //GET DET VIA MODEL => SAVE
        $et = Commande_et::on($db)->find($all['commande']['ID_COMMANDE_ET']);
        $et->NOM = $all['commande']['NOM'];
        $et->EMAIL = $all['commande']['EMAIL'];
        $et->DATE_LIVRAISON = $all['commande']['DATE_LIVRAISON'];
        $et->save();
        $arr_last['et'] = $et;
        foreach ($all['commande']['det'] as $key => $new) {
            $det = Commande_det::on($db)->find($new['ID_COMMANDE_DET']);
            $det->Q = $new['Q'];
            $det->save();
            $all_last[$key] = $det;
        }

        return ($all);
    }
    public function DeleteDet(Request  $request, $db, $id)
    {
        $et = Commande_det::on($db)->find($id)->et;
        if (count($et->det) <= 1) {
            $et->delete();
        }
        Commande_det::on($db)->find($id)->delete();
    }
    public function DeleteEt(Request  $request, $db, $id)
    {
        $et = Commande_et::on($db)->find($id);
        $et->det()->delete();
        $et->delete();
    }
    public function GetCommande($db, $id)
    {
        $Commande_et = Commande_et::on($db)->find($id);
        $Commande_det = $Commande_et->det;
        // $Commande_et->NOTE=utf8_encode(json_encode($Commande_et->NOTE));
        // dd($Commande_et);
        // $Commande_et->NOTE=base64_decode($Commande_et->NOTE);$Commande_et->USERAGENT=base64_decode($Commande_et->USERAGENT);

        // $Commande_et= Commande_et::select('NOM','DATE_LIVRAISON', 'POINT_LIVRAISON', 'EMAIL' )->where('ID_COMMANDE_ET', $id)->get();
        // dd($Commande_det);die;
        return ($Commande_et);
    }
    public function getArticles($db)
    {
        $i = 0;
        $article_last = '';
        $articles = Article::on($db)->select("REFERENCE", "DESIGNATION", "PRIX_VENTE_HT")->where("FORM_WEB", "=", "X")->orderBy("REFERENCE", "ASC")->get();
        $datas = $articles->all();
        $datas = json_decode(json_encode($datas), true);
        foreach ($datas as $index => $data) {
            $article = substr($data['REFERENCE'], 0, strpos($data['REFERENCE'], '_'));
            if (($article_last != '') && $article != $article_last) {
                $i = 0;
            }
            $articles_send[$article][$i] = '';
            $articles_send[$article][$i] = $data;
            $article_last = $article;
            $i = $i + 1;
        }
        return (($articles_send));
    }
    public function getArticlesAll($db)
    {
        $i = 0;
        $articles = Article::on($db)->select("REFERENCE", "DESIGNATION", "PRIX_VENTE_HT")->where("FORM_WEB", "=", "X")->orderBy("REFERENCE", "ASC")->get();
        return ($articles);
    }
    public function GetMessageManuel($db)
    {

        //$message = DB::connection($db)->table('aide_message_form_web')->select("MESSAGE_AFF")->where("INTRO", "=", "X")->first();
        //$datas = json_encode(mb_convert_encoding($message->MESSAGE_AFF, "UTF-8"));

        /* 04/12/2024 On bypass le message qui dans  la bdd à cause des accents ! */

        return ('<p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1">
              <strong>PASSER UNE COMMANDE</strong>
            </span></p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <br>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="background-color: rgb(255, 0, 0); color: rgb(255, 255, 255);">
              <strong><span style="font-size: 11pt;" data-mce-style="font-size: 11pt;">POINT ESSENTIEL POUR LES PROS : </span>
              </strong>
            </span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="background-color: rgb(255, 0, 0); color: rgb(255, 255, 255);">
              <strong>
                <span style="font-size: 11pt;" data-mce-style="font-size: 11pt;">
                  Vos commandes pour le DIMANCHE doivent être passées le jeudi 19h00 au plus tard, au-delà c\'est hors délai (tout est décrit ci-dessous) et nous ne pourrons vous livrer.</span>
              </strong>
            </span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <br>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="background-color: rgb(255, 255, 0);">
        La Boutique de LA JARNE est fermée tous les jeudi d\'aôut.</span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <br data-mce-bogus="1">
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              Veuillez renseigner votre <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              nom</strong>
              , numéro de<strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              &nbsp;</strong>
              <strong>
                téléphone</strong>
              &nbsp;et <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              email</strong>
              (optionnel).</span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              Puis sélectionnez le <strong>
              point de vente</strong>
              de votre choix, la<strong>
              date de livraison</strong>
              (qui est fonction du jour de livraison du point de vente) et cliquez sur "Select"</span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <br>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              Choisissez les <strong>
              quantités</strong>
              &nbsp;souhaitées&nbsp;par <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              type de pain</strong>
              , puis cliquez sur "COMMANDER"</span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <br>
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              Pour les pro, veuillez cocher la case "pro" puis renseignez votre identifiant.</span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <br>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              <strong>
                Attention, les commandes doivent </strong>
              <strong>
                être</strong>
              <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
                &nbsp;</strong>
              <strong>
                passées</strong>
              <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
                &nbsp;48h AVANT :</strong>
            </span>
            <br>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              Pour une livraison le </span>
            <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              mardi</strong>
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              , passez commande le</span>
            <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              dimanche</strong>
            <span style="background-color: rgb(0, 255, 0);" data-mce-style="background-color: #00ff00;">
              <strong>
                <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
                  avant 19h</span>
              </strong>
            </span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              Pour une livraison le</span>
            <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              mercredi</strong>
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              , passez commande le </span>
            <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              lundi</strong>
            <span style="background-color: rgb(0, 255, 0);" data-mce-style="background-color: #00ff00;">
              <strong>
                <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
                  avant 19h</span>
              </strong>
            </span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              Pour une livraison le </span>
            <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              jeudi</strong>
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              , passez commande le </span>
            <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              mardi</strong>
            <span style="background-color: rgb(0, 255, 0);" data-mce-style="background-color: #00ff00;">
              <strong>
                <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
                  avant 19h</span>
              </strong>
            </span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              Pour une livraison le </span>
            <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              vendredi</strong>
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
              , passez commande le </span>
            <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              mercredi</strong>
            <span style="background-color: rgb(0, 255, 0);" data-mce-style="background-color: #00ff00;">
              <strong>
                <span style="font-family: helvetica; font-size: 12pt;" data-mce-mark="1" data-mce-style="font-family: helvetica; font-size: 12pt;">
                  avant 19h</span>
              </strong>
            </span>
          </p>
          <p style="text-align: center;" data-mce-style="text-align: center;">
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              Pour une livraison le </span>
            <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              samedi et le dimanche</strong>
            <span style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              , passez commande le</span>
            <strong style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
              jeudi</strong>
            <span style="background-color: rgb(0, 255, 0);" data-mce-style="background-color: #00ff00;">
              <strong>
                <span style="font-family: helvetica; font-size: 12pt;" data-mce-style="font-family: helvetica; font-size: 12pt;">
                  avant 19h</span>
              </strong>
            </span>
          </p>
');
    }
    public function GetMessageRecap($db)
    {
        $message = DB::connection($db)->table('aide_message_form_web')->select("MESSAGE_AFF")->where("RECAP", "=", "X")->first();
        $datas = json_encode(utf8_encode($message->MESSAGE_AFF));
        return ($datas);
    }
    public function getPointsLivraison($db)
    {
        if ($db == 'leguillon' ) {
            $pLivraison = DB::connection($db)->table('aide_points_livraisons')->select("DESIGNATION", "N_REGROUPEMENT", "N_JOURS")->where("ACTIF", "=", "X")->get();
            $datas = $pLivraison->all();
            return ($datas);
        } else {
            $pLivraison = DB::connection($db)->table('aide_points_livraisons')->select("DESIGNATION", "N_REGROUPEMENT", "N_JOURS")->where("ACTIF", "=", "X")->where("ORDRE_AFFICHAGE_FORM", "!=", 0)->orderBy('ORDRE_AFFICHAGE_FORM')->get();
            $datas = $pLivraison->all();
            return ($datas);
        }
    }
    public function getDateAbo(Request $request, $db)
    {
        $dates = DB::connection($db)->table('aide_date_abo')->select("DATE_DEBUT", "DATE_FIN", "VACANCES")->where("ACTIF", "=", "X")->first();
        $period = new DatePeriod(
            new DateTime($dates->DATE_DEBUT),
            new DateInterval('P1D'),
            new DateTime($dates->DATE_FIN)
        );
        $request->all();
        $jours = explode(",", $request->N_JOURS);
        foreach ($period as $key => $value) {
            if (in_array($value->format('w'), $jours)) {
                $datas[$key]['dateAbo'] = $value->format('d/m/Y');
                $datas[$key]['dateAboclean'] = $value->format('Y-m-d');
                $datas[$key]['vacances'] = $dates->VACANCES;
                $articles = Article::on($db)->select("REFERENCE", "DESIGNATION", "PRIX_VENTE_HT")->where("FORM_WEB", "=", "X")->orderBy("ETAGERE", "ASC")->get();
                $datas[$key]['articles'] = $articles->all();
                array_map(function ($item) {
                    $item['PRIX_VENTE_HT'] = $item['PRIX_VENTE_HT'] + 5.5 / 100 * $item['PRIX_VENTE_HT'];
                    $item['PRIX_VENTE_HT'] = number_format($item['PRIX_VENTE_HT'], 2);
                }, $datas[$key]['articles']);
            }
        }
        return (array_values($datas));
    }
    public function CreateAbonnement(Request $request, $db)
    {
        $request->all();
        $datas = $request->all();
        // return ($datas);
        $idAbonnement = Str::random(32);
        $now = date('Y-m-d');
        Commande_abonnement::on($db)->create(['ID_COMMANDE_ABONNEMENT' => $idAbonnement, 'NOM' => $datas['NOM'], 'PRENOM' => $datas['PRENOM'], 'DATE_COMMANDE' => $now, 'TEL' => $datas['TEL'], 'EMAIL' => $datas['EMAIL'], 'DESIGNATION' => $datas['DESIGNATION'], 'TOTAL' => $datas['TOTAL']]);
        foreach ($datas['ABONNEMENT'] as $commande) {
            // return ($idAbonnement);
            $flag = 0;
            foreach ($commande['articles'] as $article) {
                if (isset($article['QUANTITE']) && $article['QUANTITE'] !== 0 && $article['QUANTITE'] != null && $flag == 0) {
                    $idEt = Str::random(32);
                    Commande_et::on($db)->create(['ID_COMMANDE_ET' => $idEt, 'NOM' => $datas['NOM'], 'IDENT_ABO' => $idAbonnement, 'DATE_LIVRAISON' => $commande['dateAboclean'], 'WEB' => 'X', 'MAIL' => $datas['EMAIL'], 'POINT_LIVRAISON' => $datas['DESIGNATION'], 'TELEPHONNE' => $datas['TEL']]);
                    $flag = 1;
                }
                if (isset($article['QUANTITE']) && $article['QUANTITE'] != 0 && $article['QUANTITE'] != null) {
                    Commande_det::on($db)->create(['ID_COMMANDE_DET' => (Str::random(32)), 'IDENT_ABO' => $idAbonnement, 'REFERENCE' => $article['REFERENCE'], 'Q' => $article['QUANTITE'], 'PRIX_VENTE_HT' => $article['PRIX_VENTE_HT'], 'DATE_LIVRAISON' => $commande['dateAboclean'], 'WEB' => 'X', 'MAIL' => $datas['EMAIL'], 'POINT_LIVRAISON' => $datas['DESIGNATION'], 'TELEPHONNE' => $datas['TEL'], 'PID_COMMANDE_ET' => $idEt, 'CODE_ARTICLE' => $article['REFERENCE'], 'DESIGNATION' => $article['DESIGNATION']]);
                }
                // return ($commande['dateAbo']);
            }
        }
    }
    public function getDisabledDates($db)
    {

        $response = [];
        $today_name = now()->format('D');
        $hour = now()->format('H');

        /* Attention la date du serveur n'est pas bonne, il faut faire +2h */

        //je suis le dimanche
        if($today_name == "Sun"){
            if($hour < 18){

            } else {
               $response[] = now()->addDays(2)->format('Y-m-d');
            }
        }

        //je suis lundi
        if($today_name == "Mon"){
            if($hour < 18){

            } else {
                $response[] = now()->addDays(2)->format('Y-m-d');
            }
        }

        //je suis mardi
        if($today_name == "Tue"){
            if($hour < 18){

            } else {
                $response[] = now()->addDays(2)->format('Y-m-d');
            }
        }

        //je suis mercredi
        if($today_name == "Wed"){
            if($hour < 18){

            } else {
                $response[] = now()->addDays(2)->format('Y-m-d');
            }
        }

        //je suis jeudi
        if($today_name == "Thu"){
            if($hour < 18){
//                $response[] = now()->addDays(2)->format('Y-m-d'); // retire le samedi suivant
//                $response[] = now()->addDays(3)->format('Y-m-d'); // retire le dimanche suivant
            } else {
                $response[] = now()->addDays(2)->format('Y-m-d'); // retire le samedi suivant
                $response[] = now()->addDays(3)->format('Y-m-d'); // retire le dimanche suivant
            }
        }

        //je suis vendredi
        if($today_name == "Fri"){
            if($hour < 18){
                $response[] = now()->addDays(1)->format('Y-m-d'); // retire le samedi suivant
                $response[] = now()->addDays(2)->format('Y-m-d'); // retire le dimanche suivant

            } else {
                $response[] = now()->addDays(1)->format('Y-m-d'); // retire le samedi suivant
                $response[] = now()->addDays(2)->format('Y-m-d'); // retire le dimanche suivant
            }
        }

        //je suis samedi
        if($today_name == "Sat"){
            if($hour < 18){

                $response[] = now()->addDays(1)->format('Y-m-d'); // retire le dimanche suivant

            } else {
                $response[] = now()->addDays(1)->format('Y-m-d'); // retire le dimanche suivant
                $response[] = now()->addDays(2)->format('Y-m-d');
            }
        }

        return response()->json($response);
     }
}
