<?php
/**
 * Exports for external clients 
 */

namespace App\Http\Controllers\ExportsClients;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Utils\SelectClient;
use App\Http\Controllers\Utils\UtilsFunctions;
use App\Models\ST\auto\document_archive;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

/**
 * Check asked database and table, then export datas
 */
class ExportDispatchv2 extends Controller
{    
    /**
     * exportDispatch
     * 
     * export datas from a simple table passed as param
     * 
     * Check db right, then get the table, then get the datas
     *
     * @param  mixed $request
     * @param  mixed $database
     * @param  mixed $table
     * @param  mixed $n_dossier
     * @param  mixed $n_ex
     * @return Json $datas
     */
    public function exportDispatch(Request $request, $database, $table, $n_dossier, $n_ex)
    {
        Log::channel('ApiCalledByExterne')->info('L\'endpoint '.$request->path().' a été appelé par un client externe.');
        ini_set('memory_limit', '2G');
        if(!SelectClient::GetSelect($table)){
            abort(response('You are authentificated, but asked the wrong table.', 404));
        }
        $select = SelectClient::GetSelect($table);
        $fields = $select[0];
        $datas = DB::connection($database)
            ->table($select[1])
            ->select(DB::raw($fields))
            ->where('SYS_DATE_CREATION', '=', date('Y-m-d'))
            ->orWhere('SYS_DATE_MODIFICATION', '=', date('Y-m-d'))
            ->when(strpos($select[0], 'N_DOSSIER'), function ($q) use ($n_dossier, $n_ex) {
                return $q->where('N_DOSSIER', '=', $n_dossier);
            })
            ->when(strpos($select[0], 'N_EXERCICE'), function ($q) use ($n_dossier, $n_ex) {
                return $q->where('N_EXERCICE', '=', $n_ex);
            })
            ->get();
        return ($datas);
    }

        
    /**
     * exportDispatchEtDet
     *
     * export datas from a table with a relation with another table
     * 
     * Check db right, then get the table, then get the datas, then get linked datas
     * @param  mixed $request
     * @param  mixed $database
     * @param  mixed $table
     * @param  mixed $n_dossier
     * @param  mixed $n_ex
     * @return Json $datas
     */
    public function exportDispatchMateriel(Request $request, $database, $table, $n_dossier, $n_ex)
    {
        Log::channel('ApiCalledByExterne')->info('L\'endpoint '.$request->path().' a été appelé par un client externe: '.$request->headers->get('referer'));
        ini_set('memory_limit', '2G');
        if(!SelectClient::GetSelect($table)){
            abort(response('You are authentificated, but asked the wrong table.', 404));
        }
        $select = SelectClient::GetSelect($table);
        $champsWithTable=explode(',', $select['et']);
        $champsWithTable=array_map(function($item) {
            $item='materiel_et.'.trim($item);
            return $item;
        }, $champsWithTable);
        // $fields = implode(', ', $champsWithTable);
        // dd($fields);
        // dd($champsWithTable);
        try {
            $all = $select['modl']::on($database)
            ->select($champsWithTable)
            ->when(strpos($select['et'], 'materiel_et.N_DOSSIER'), function ($q) use ($n_dossier, $n_ex) {
                return $q->where('materiel_et.N_DOSSIER', '=', $n_dossier);
            })
            ->when(strpos($select['et'], 'materiel_et.N_EXERCICE'), function ($q) use ($n_dossier, $n_ex) {
                return $q->where('materiel_et.N_EXERCICE', '=', $n_ex);
            })
            ->Where('materiel_et.SYS_DATE_MODIFICATION', '=', date('Y-m-d'))
            ->get(); // WORKING TO GET ALL 
            foreach($all as $key => $ligne){
                $doc = document_archive::on('pdl')->where('PID_MATERIEL_ET', $ligne->ID_MATERIEL_ET)->where('CARTE_GRISE', 'X')->get()->first();
                if($doc){
                    $doc=base64_encode(file_get_contents("/var/www/eglobalpro/htdocs/$doc->NOM_REP/dossiers/$doc->NOM_REP/documents/$doc->NOM_DOSSIER/$doc->LIEN_DOCUMENT_ARCHIVE"));
                    $all[$key]->carteGrise= $doc;
                }
                
                // 
                // dd($all[$key]->det);
                
            }
            // dd($all->toArray());
        } catch (Exception $e) {
            echo $e->getMessage();exit;
        }
        // $alls = $all->toArray();
        // dd($all);
        // foreach ($alls as $key => $ligne) {
        //     foreach ($ligne as $namechamp => $datachamps) {
        //         if (!strpos($select['et'], $namechamp)) {
        //             if ($namechamp !== 'det') {
        //                 unset($alls[$key][$namechamp]);
        //             } else {
        //                 if (count($datachamps) >= 1) {
        //                     $datachamps=UtilsFunctions::array_sort($datachamps, 'KM_FIN', SORT_DESC);
        //                     $alls[$key][$namechamp]=array_values($datachamps); 
        //                     foreach ($datachamps as $nomchampdet => $datadet) {
        //                         if($nomchampdet !== 0){
        //                             unset($alls[$key][$namechamp][$nomchampdet]);
        //                         }
        //                         foreach ($datadet as $nomder => $datadets) {
        //                             if (!strpos($select['det'], $nomder)) {
        //                                 unset($alls[$key][$namechamp][$nomchampdet][$nomder]);
        //                             }
        //                         }
        //                     }
        //                 }
        //             }
        //         }
        //     }
        //     // dd($ligne);
        // }
        return ($all->toArray());
    }

        
    /**
     * exportDispatchRh
     * 
     * export datas from a table human ressources related
     * 
     * @todo Deal with RGPD and other security issues
     *
     * @param  mixed $database
     * @param  mixed $table
     * @param  mixed $n_dossier
     * @param  mixed $n_ex
     * @return Json $datas
     */
    public function exportDispatchRh(Request $request,$database, $table, $n_dossier, $n_ex)
    {
        Log::channel('ApiCalledByExterne')->info('L\'endpoint '.$request->path().' a été appelé par un client externe: '.$request->headers->get('referer'));
        ini_set('memory_limit', '2G');
        $select = SelectClient::GetSelectRh($table, $database);
        $fields = $select[0];
        $datas = DB::connection($database)
            ->table($select[1])
            ->select(DB::raw($fields))
            ->when(strpos($select[0], 'N_DOSSIER'), function ($q) use ($n_dossier) {
                return $q->where('N_DOSSIER', '=', $n_dossier);
            })
            ->when(strpos($select[0], 'N_EXERCICE'), function ($q) use ($n_ex) {
                return $q->where('N_EXERCICE', '=', $n_ex);
            })
            ->where('SYS_DATE_CREATION', '=', date('Y-m-d'))
            ->orWhere('SYS_DATE_MODIFICATION', '=', date('Y-m-d'))
            ->get();
            $datas = $datas->toArray();
            // dd($datas);
            $datas = array_map(function($item) {
                // $item=$item->toArray();
                // dd($item->NOM_SALARIE);
                if( isset($item->NOM_SALARIE)){
                $names=explode(' ', $item->NOM_SALARIE);
                // dd($names);
                $item->NOM= isset($names[0]) ? $names[0] : 'Vide';
                $item->PRENOM= isset($names[1]) ? $names[1] : 'Vide';
            }
                return $item;
            
            },
                 $datas);
            // dd($datas);
        return ($datas);
    }
}
