<?php

namespace App\Http\Controllers\InterfacesApi\numeria;

use App\Http\Controllers\Controller;
use App\Models\ST\auto\document_archive;
use App\Models\ST\auto\document_signature;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;

class GetDoc extends Controller
{
    static function getDocBase($db, $id){
        $datas= document_signature::on($db)->find($id);
        $array['login'] = env('NUMERIALOGIN');
        $array['password'] = env('NUMERIAPASSWORD');
        $array['documents'] = [$datas->DOCUUID_NUMERIA];
        // dd($Json)
        $response = Http::post(env('NUMERIABASEURL').'documentsLoad',$array);
        if($response->status()==200){
            // dd($response->body());
            return $response;
        }else{
            return Response($response->body(),$response->status(), ['Content-Type' => 'application/json']);
        }
    }
        public function getDocSolo($db, $id){
            $response=$this->getDocBase($db, $id);
            $datas= document_signature::on($db)->find($id);
            $result=json_decode($response);
            $datas->DOC_BASE_64_CLEAN='data:application/pdf;base64,'.$result[0]->fichier_data;
            $datas->save();
            $arr[0]=$datas;
            $document_archive= document_archive::on($db)->where('PID_DOCUMENT_ARCHIVE', $datas->ID_DOCUMENT_SIGNATURE)->first();
            if(!$document_archive){
                $id=Str::random(32);
                $document_archive= document_archive::on($db)->create([
                'ID_DOCUMENT_ARCHIVE' => "$id",
                'PID_DOCUMENT_ARCHIVE' => "$datas->ID_DOCUMENT_SIGNATURE",
                'NOM_DOSSIER'=> "$datas->NOM_DOSSIER",
                'N_DOSSIER'=> $datas->N_DOSSIER,
                'NOM_FICHIER_NOM'=> "$datas->DOC_FICHIER_NOM",
                'NOM_FICHIER_CONTENU'=> "$datas->DOC_BASE_64_CLEAN",
                'NOM_FICHIER_TYPE'=> "$datas->DOC_FICHIER_TYPE",
                'NOM_FICHIER_TAILLE'=> $datas->DOC_FICHIER_TAILLE,
                'NOM_FICHIER_DATE'=> "$datas->DOC_FICHIER_DATE",
                'PID_TIERS'=> "$datas->PID_TIERS",
                'LIEN_DOCUMENT_ARCHIVE'=>"$id.pdf",
            ]);}else{
                $document_archive->NOM_FICHIER_CONTENU=$datas->DOC_BASE_64_CLEAN;
                $document_archive->save();
            }
        // dd($datas->toArray());
            return view('docsent', ['datas' =>$arr]);
        }

        public function getDocAll($db){
            $toGet=document_signature::on($db)->where('status',300)->get();
            $datas=[];
            $i=0;
            foreach ($toGet as $key => $value) {
                $response=$this->getDocBase($db, $value->ID_DOCUMENT_SIGNATURE);
                $result=json_decode($response);
                $value->DOC_BASE_64_CLEAN='data:application/pdf;base64,'.$result[0]->fichier_data;
                $value->save();
                // $i=$i+1;
                array_push($datas, $value);
                $document_archive= document_archive::on($db)->where('PID_DOCUMENT_ARCHIVE', $value->ID_DOCUMENT_SIGNATURE)->first();
                if(!$document_archive){
                    $id=Str::random(32);
                    $document_archive= document_archive::on($db)->create([
                    'ID_DOCUMENT_ARCHIVE' => "$id",
                    'PID_DOCUMENT_ARCHIVE' => "$value->ID_DOCUMENT_SIGNATURE",
                    'NOM_DOSSIER'=> "$value->NOM_DOSSIER",
                    'N_DOSSIER'=> $value->N_DOSSIER,
                    'NOM_FICHIER_NOM'=> "$value->DOC_FICHIER_NOM",
                    'NOM_FICHIER_CONTENU'=> "$value->DOC_BASE_64_CLEAN",
                    'NOM_FICHIER_TYPE'=> "$value->DOC_FICHIER_TYPE",
                    'NOM_FICHIER_TAILLE'=> $value->DOC_FICHIER_TAILLE,
                    'NOM_FICHIER_DATE'=> "$value->DOC_FICHIER_DATE",
                    'PID_TIERS'=> "$value->PID_TIERS",
                    'LIEN_DOCUMENT_ARCHIVE'=>"$id.pdf",
                ]);}else{
                    $document_archive->NOM_FICHIER_CONTENU=$value->DOC_BASE_64_CLEAN;
                    $document_archive->save();
                }
            }
            return view('docsent', ['datas' => $datas]);
        }
}
