<?php

namespace App\Http\Controllers\InterfacesApi\numeria;

use App\Http\Controllers\Controller;
use App\Models\ST\auto\document_signature;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class SendDoc extends Controller
{
    public function sendDocBase($db, $id){
        $datas= document_signature::on($db)->find($id);
        $Json=FormatJson::getJson(substr($datas->DOC_FICHIER_CONTENU,28), $datas->DEST_1_CIVILITE, $datas->DEST_1_NOM, $datas->DEST_1_PRENOM, $datas->NOM_TIERS, $datas->DEST_1_MAIL, $datas->DEST_1_ADR, $datas->DEST_1_CP, $datas->DEST_1_VILLE, $datas->DOCINFO1,$datas->DOCINFO2, $datas->DOCINFO3,$datas->DOCINFO4,str_replace(' ','',$datas->NOM_MODL),$datas->SIGN_NB);
        // dd(json_encode($Json));
        // $send=json_encode($Json);
        // dd($send);
        $response = Http::withHeaders( ['Content-Type' => 'application/json'])->post(env('NUMERIABASEURL').'documentsAdd',$Json);
        if($response->status()==200){
            return $response;
        }else{
            return Response($response->body(),$response->status());
        }
    }
    public function SendDocSolo($db, $id){
        $response=$this->sendDocBase($db, $id);
        $datas= document_signature::on($db)->find($id);
        $result=json_decode($response);
        $datas->DOCUUID_NUMERIA=$result[0]->docUUID;
        $datas->STATUSINFO='Document envoyé';
        $datas->save();
        dd($datas->toArray());
    }
    public function sendDocAll($db){
        $toSend=document_signature::on($db)->where('LOT_ENVOIE','X')->where('STATUS','!=',300)->get();
        $datas=[];
        $i=0;
        foreach ($toSend as $key => $value) {
            $response=$this->sendDocBase($db, $value->ID_DOCUMENT_SIGNATURE);
            $result=json_decode($response);
            $value->DOCUUID_NUMERIA=$result[0]->docUUID;
            $value->STATUSINFO='Document envoyé';
            $value->save();
            array_push($datas, $value);
        }
        // dd($toSend);
        // return $toSend;
        return view('docsent', ['datas' => $datas]);
    }
}
