<?php

namespace App\Http\Controllers\InterfacesApi\webfleet;

use App\Http\Controllers\Controller;
use App\Services\ApiLogManager;
use Illuminate\Http\Request;
use App\Models\ST\Parc\materiel\Materiel_det;
use App\Models\ST\Parc\materiel\Materiel_et;
use Illuminate\Support\Str;
use App\Http\Controllers\InterfacesApi\MultiDbController;
use Illuminate\Support\Facades\Storage;

class ImportKms extends Controller
{
    public function webfleetImportKms()
    {
        $started_at = now()->format('Y-m-d H:i:s');
        ob_start();
        $start=microtime(true);

        // Récupération des données à importer (en JSON)
        $datas = $this->GetKmspdl();
        // $datas = Storage::disk('public')->get('kms.json');
        $datas = json_decode($datas);

        foreach ($datas as $data) {
            // Recherche du matériel correspondant au numéro d'immatriculation
            $et = Materiel_et::on('pdl')
                ->where('IMMATRICULATION', trim($data->objectname))
                ->first();
            if($et == null) continue;

            if (isset($data->odometer)) {
                // Récupération du km_fin_max et de la date_debut pour l'étiquette
                $km_fin_max = $et->det->max('KM_FIN');
                $date_fin_max = $et->det->max('FIN');

                // Au cas ou on aurait $et et rien dans det ...
                if($km_fin_max == null ){
                    $km_fin_max = $data->odometer;
                    $date_fin_max = date('Y-m-d');
                }

                if ($km_fin_max < $data->odometer) {
                    // Création d'un nouveau matériel détaillé si le km_fin_max est inférieur au km valeur de l'import
                    $test = Materiel_det::on('pdl')
                        ->create([
                            'ID_MATERIEL_DET' => Str::random(32),
                            'IMMAT' => $data->objectname,
                            'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
                            'FIN' => date('Y-m-d'),
                            'KM_FIN' => ($data->odometer_long / 1000),
                            'KM_DEBUT' => $km_fin_max,
                            'SYS_USER_CREATION' => 'IMPORT_WEBFLEET',
                            'SYS_USER_MODIFICATION' => 'IMPORT_WEBFLEET',
                            'DEBUT' => $date_fin_max,
                        ]);
                }
                else
                {
                    // Cas où il n'y a pas encore d'enregistrements de détails
                    // Création du premier enregistrement Materiel_det
                    Materiel_det::on('pdl')
                        ->create([
                            'ID_MATERIEL_DET' => Str::random(32),
                            'IMMAT' => $data->objectname,
                            'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
                            'FIN' => date('Y-m-d'),
                            'KM_FIN' => ($data->odometer_long / 1000),
                            'KM_DEBUT' => ($data->odometer_long / 1000),
                            'SYS_USER_CREATION' => 'IMPORT_WEBFLEET',
                            'SYS_USER_MODIFICATION' => 'IMPORT_WEBFLEET',
                            'DEBUT' => date('Y-m-d'),
                        ]);
                }
            }
        }

        $end=microtime(true);
        $phpinfo=ob_get_contents();
        ob_end_clean();
        $time=$end-$start;

        $finished_at = now()->format('Y-m-d H:i:s');
        (new ApiLogManager())
            ->log(
                "import",
                "WEBFLEET",
                $started_at,
                $finished_at,
                count($datas),
                $time,
                [],
            );


        // Retour d'une chaîne de caractères indiquant que l'import est terminé
        return 'Done';


        /*
        $datas = $this->GetKmspdl();
        // $datas=Storage::disk('public')->get('kms.json');
        $datas = json_decode($datas);
        foreach ($datas as $data) {
            $et = Materiel_et::on('pdl')->where('IMMATRICULATION', trim($data->objectname))->first();
            // dd($et->ID_MATERIEL_ET);
            if ($et && isset($data->odometer)) :
                $km_fin_max = $et->det->max('KM_FIN');
                $date_fin_max = $et->det->max('FIN');
                if ($km_fin_max < $data->odometer) :
                    $test = Materiel_det::on('pdl')->create(['ID_MATERIEL_DET' => Str::random(32), 'IMMAT' => $data->objectname, 'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET, 'FIN' => date('Y-m-d'), 'KM_FIN' => ($data->odometer_long / 1000), 'KM_DEBUT' => $km_fin_max, 'SYS_USER_CREATION' => 'IMPORT_WEBFLEET', 'SYS_USER_MODIFICATION' => 'IMPORT_WEBFLEET', 'DEBUT' => $date_fin_max]);
                endif;
            endif;
        };
        return 'Done';
        */
    }

    static function GetKmspdl()
    {
        $curl = curl_init();
        $mdp = 'DT:Hz?8ZK.7wfmk%26dE~JJb^BPt}h!_Kzp/Tw!o%26pC?MXk~GFaA7$r,QV/{nRw.!u';
        $apiKey = 'f4fccf8c-193f-47f1-9b74-62ab3bb5c197';
        $url = "https://csv.webfleet.com/extern?lang=en&account=distribution-logistique&username=EGLOBAL&password=$mdp&outputformat=json&apikey=$apiKey&action=showObjectReportExtern";
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        // print_r($url);die;
        $response = curl_exec($curl);
        // print_r($response);
        curl_close($curl);
        try {
            Storage::disk('public')->put('kms.json', $response);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
        return $response;
    }
}
