<?php

/**
 * blablatest
 *
 * 
 */

namespace App\Http\Controllers\NewClientsCreation;

use App\Http\Controllers\Controller;
use App\Models\ST\auto\aide_plan_comptable;
use App\Models\ST\auto\comptabilit_et;
use App\Models\ST\auto\comptabilit_det;
use App\Models\ST\auto\tiers;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Nette\Utils\Random;

/**
 * SqueletteController
 */
class ImportFromFec extends Controller
{
    /**
     * Summary of index
     * @param \Illuminate\Http\Request $request
     * @return void
     */
    public function index(request $request)
    {
        //RECUP DOSSIERS/EX/CPTES
        // IF EXERCICE AND COMPTES SONT EN JSON OU DANS LE BODY :
        $dossier = $request->dossier['dossier'];
        $n_dossier = $request->dossier['nDossier'];
        //check if EX has .json
        if (is_array($request->exercices['exercices'])) {
            $exercices = $request->exercices['exercices'];
        } else {
            $nomFile = $request->exercices['exercices'];
            $exercices = file_get_contents(storage_path("app/file/newClient/configs/$nomFile"));
        }

        //CPTES
        if (is_array($request->cptes['cptes'])) {
            $cptes = $request->cptes['cptes'];
        } else {
            $nomFile = $request->cptes['cptes'];
            $cptes = file_get_contents(storage_path("app/file/newClient/configs/$nomFile"));
        }
        //CODES JOURNAL 
        if (is_array($request->codes['codes'])) {
            $codes = $request->codes['codes'];
        } else {
            $nomFile = $request->codes['codes'];
            $codes = file_get_contents(storage_path("app/file/newClient/configs/$nomFile"));
        }
        //GET FEC.TXT
        $fileAll = trim(file_get_contents(storage_path("app/file/newClient/FEC.txt")));
        $lignes = explode("\r\n", $fileAll);
        foreach ($lignes as $keyLignes => $ligne) {
            $lignes[$keyLignes] = explode("\t", $ligne);
        }

        //Map les fields (EGP => FEC)
        $map = $this->mapFields();
        $lignes[0] = array_map(function ($field) use ($map) {
            if (isset($map[$field])) {
                return $map[$field];
            } else {
                return $field;
            }
        }, $lignes[0]);
        //unset enttes
        unset($lignes[count($lignes) - 1]);
        //Combine both array to have 'FIELDNAME' => 'VALUE' for import
        $lignes = array_map(function ($ligne) use ($lignes) {
            return array_combine($lignes[0], $ligne);
        }, array_slice($lignes, 1));

        // FOREACH where everything is done
        foreach ($lignes as $ligne) {

            //check for same EcritureNum(TO insert only one et)
            if (isset($last) && $last == $ligne['EcritureNum']) {
                $last = $ligne['EcritureNum'];

                //TENTATIVE DOUBLE DET

            //AJOUTS/MODIFS DES CHAMPS


            $last = $ligne['EcritureNum'];
            $ligne = mb_convert_encoding($ligne, 'UTF-8', 'ISO-8859-1');
            $ligne['DEBIT'] = str_replace(",", ".", $ligne['DEBIT']);
            $ligne['CREDIT'] = str_replace(",", ".", $ligne['CREDIT']);
            $ligne['N_DOSSIER'] = $n_dossier;
            $ligne['NOM_DOSSIER'] = $dossier;
            $ligne['N_IMPORT'] = "FEC" . $ligne['DATE'];
            $ligne['DATE'] = date("Y-m-d", strtotime($ligne['DATE']));
            if(!empty($ligne['DATE_TRESO'])){
                $ligne['DATE_TRESO'] = date("Y-m-d", strtotime($ligne['DATE_TRESO']));
            }else{
                $ligne['DATE_TRESO'] = null;
            }
            if(!empty($ligne['DATE_LETTRAGE'])){
                $ligne['DATE_LETTRAGE'] = date("Y-m-d", strtotime($ligne['DATE_LETTRAGE']));
            }else{
                $ligne['DATE_LETTRAGE'] = null;
            }
            if(!empty($ligne['DATE_CLOTURE_EXERCICE'])){
                $ligne['DATE_CLOTURE_EXERCICE'] = date("Y-m-d", strtotime($ligne['DATE_CLOTURE_EXERCICE']));
            }else{
                $ligne['DATE_CLOTURE_EXERCICE'] = null;
            }
            $ligne['DATE_ECHEANCE'] = $ligne['DATE_TRESO'];
            $ligne['ID_COMPTABILIT_ET'] = Random::generate(32);
            $ligne['ID_COMPTABILIT_DET'] = Random::generate(32);
            $ligne['N_ECRITURE_FEC_IMPORT'] = $ligne['EcritureNum'];

            if($ligne['DATE_CLOTURE_EXERCICE']!=''){
                $ligne['BLOCAGE_EXERCICE'] = 'X';
                $ligne['CLOTURE_EXERCICE'] = 'X';
            }
            $lettres = $this->mapLettrage();
            if (isset($ligne['EcritureLet'])) {
                $ligne['EcritureLet'] = $lettres[$ligne['EcritureLet']];
            } else {
                $ligne['EcritureLet'] = null;
            }
            //AJOUTS/MODIFS DES CHAMPS en dur 
            $ligne['BLOCAGE_ECRITURE'] = 'X';
            if(isset($ligne['CompAuxNum'])){
                $ligne['N_CPTE_FEC'] = $ligne['CompAuxNum'];
            }
            //Exercices
            foreach (json_decode($exercices) as $exercice) {
                if ($ligne['DATE'] >= $exercice->dateD && $ligne['DATE'] <= $exercice->dateF) {
                    $ligne['N_EXERCICE'] = $exercice->nExercice;
                }
            }
            //Codes journaux
            foreach (json_decode($codes) as $code) {
                if ($ligne['CODE_JOURNAL'] == $code->codeFec) {
                    $ligne['CODE_JOURNAL'] = $code->codeEgp;
                }
            }
            // Comptes (For det only)
            foreach (json_decode($cptes) as $compte) {
                if ($ligne['N_CPTE_GENERAL'] == $compte->nCpteFec) {
                    $ligne['N_CPTE_GENERAL'] = $compte->nCpteEgp;
                }else{
                }
            }
            //save
            // $model = new comptabilit_det();
            //et
            $model = new comptabilit_det();
            $model->setConnection('lanwest');
            $model->fill($ligne);
            $model->save();
                continue;
            }

            //AJOUTS/MODIFS DES CHAMPS variables
            $last = $ligne['EcritureNum'];
            $ligne = mb_convert_encoding($ligne, 'UTF-8', 'ISO-8859-1');
            $ligne['DEBIT'] = str_replace(",", ".", $ligne['DEBIT']);
            $ligne['CREDIT'] = str_replace(",", ".", $ligne['CREDIT']);
            $ligne['N_DOSSIER'] = $n_dossier;
            $ligne['NOM_DOSSIER'] = $dossier;
            $ligne['N_IMPORT'] = "FEC" . $ligne['DATE'];
            $ligne['DATE'] = date("Y-m-d", strtotime($ligne['DATE']));
            if(!empty($ligne['DATE_TRESO'])){
                $ligne['DATE_TRESO'] = date("Y-m-d", strtotime($ligne['DATE_TRESO']));
            }else{
                $ligne['DATE_TRESO'] = null;
            }
            if(!empty($ligne['DATE_LETTRAGE'])){
                $ligne['DATE_LETTRAGE'] = date("Y-m-d", strtotime($ligne['DATE_LETTRAGE']));
            }else{
                $ligne['DATE_LETTRAGE'] = null;
            }
            if(!empty($ligne['DATE_CLOTURE_EXERCICE'])){
                $ligne['DATE_CLOTURE_EXERCICE'] = date("Y-m-d", strtotime($ligne['DATE_CLOTURE_EXERCICE']));
            }else{
                $ligne['DATE_CLOTURE_EXERCICE'] = null;
            }
            $ligne['DATE_ECHEANCE'] = $ligne['DATE_TRESO'];
            $ligne['ID_COMPTABILIT_ET'] = Random::generate(32);
            $ligne['ID_COMPTABILIT_DET'] = Random::generate(32);
            $ligne['N_ECRITURE_FEC_IMPORT'] = $ligne['EcritureNum'];
            if($ligne['DATE_CLOTURE_EXERCICE']!=''){
                $ligne['BLOCAGE_EXERCICE'] = 'X';
                $ligne['CLOTURE_EXERCICE'] = 'X';
            }
            $lettres = $this->mapLettrage();
            if (isset($ligne['EcritureLet'])) {
                $ligne['EcritureLet'] = $lettres[$ligne['EcritureLet']];
            } else {
                $ligne['EcritureLet'] = null;
            }
            //AJOUTS/MODIFS DES CHAMPS en dur 
            $ligne['BLOCAGE_ECRITURE'] = 'X';
            if(isset($ligne['CompAuxNum'])){
            $ligne['N_CPTE_FEC'] = $ligne['CompAuxNum'];
        }

            // ICIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII

            //RESTE A FAIRE : 
            //DET :
            // PID_COMPTABILIT_ET => Crer champs dans lanwest (NFEC ou un truc comme ca (et+det) y mettre le EcritureNum et les linker comme ca) : DONE

            //IDENTIFICATION_TIERS : A VOIR AVEC CH. (Champs de liaison)
            //N_CPTE_TIERS :  Same

            //NOM_compte genral  : A VOIR AVEC La (pas compris ce que c'est)

            //N_ECRITURE : COURAGE (Compteur chelou silvertool)


            //ET : 

            //DEBIT: Somme des debits det
            //CREDIT : Somme des credits det

            //N_ECRITURE : COURAGE (Compteur chelou silvertool) (utiliser celui d'et si deja fait)

            //COMPTAGE_TIERS : A voir avec La (Pas comrpis ce que c'est)

            //COMPTAGE_LIGNE : Comptage des lignes de det


            //Dealing with exercices (sent from user, or in json file)
            foreach (json_decode($exercices) as $exercice) {
                if ($ligne['DATE'] >= $exercice->dateD && $ligne['DATE'] <= $exercice->dateF) {
                    $ligne['N_EXERCICE'] = $exercice->nExercice;
                }
            }
            //Codes journaux
            foreach (json_decode($codes) as $code) {
                if ($ligne['CODE_JOURNAL'] == $code->codeFec) {
                    $ligne['CODE_JOURNAL'] = $code->codeEgp;
                }
            }
            //cptes
            foreach (json_decode($cptes) as $compte) {
                if ($ligne['N_CPTE_GENERAL'] == $compte->nCpteFec) {
                    $ligne['N_CPTE_GENERAL'] = $compte->nCpteEgp;
                }else{
                }
            }
            // $ligne['NOM_COMPTE_GENERAL']= aide_plan_comptable::on('lanwest')->where('N_CPTE8',$ligne['N_CPTE_GENERAL'])->first()->NOM_COMPTE_GENERAL;
            //save
            $model = new comptabilit_et();
            $model->setConnection('lanwest');
            $model->fill($ligne);
            $model->save();


            $model = new comptabilit_det();
            $model->setConnection('lanwest');
            $model->fill($ligne);
            $model->save();
        }
    }    
    /**
     * linkFec
     *
     * @param  mixed $nom_simple
     * @return void
     */
    public function linkFec($nom_simple)
    {
        $ets = comptabilit_et::on('lanwest')->orderBy('DATE', 'ASC')->get();

        foreach ($ets as $et) {
            $det = comptabilit_det::on('lanwest')->where('N_ECRITURE_FEC_IMPORT', $et->N_ECRITURE_FEC_IMPORT)->get('N_CPTE_FEC');
            // $det = DB::connection('lanwest')->table("comptabilit_det")->where('N_ECRITURE_FEC_IMPORT',$et->N_ECRITURE_FEC_IMPORT)->get();
            foreach ($det as $dets) {
                $dets->PID_COMPTABILIT_ET = $et->ID_COMPTABILIT_ET;
                // dd($dets);
                $tiers=tiers::on('lanwest')->where('N_CPTE_FEC', $dets->N_CPTE_FEC)->first();
                if ($tiers != null && $dets->N_CPTE_FEC != null) {
                    $dets->IDENTIFICATION_TIERS =  $tiers->ID_TIERS;
                    $dets->N_CPTE_TIERS =$tiers->CODE_CLIENT;
                }
                echo 'last before bug : '.$et->ID_COMPTABILIT_ET;
                $dets->save();
            }
        }
    }   
    public function linkFec2($nom_simple){
        $ets = comptabilit_et::on('lanwest')->orderBy('N_DOSSIER','ASC')->orderBy('N_EXERCICE','ASC')->orderBy('DATE','ASC')->get();
        Storage::disk('local')->put('file/tests/ets.json', json_encode($ets));
        $compteur= 1;
        $nex=0;
        foreach($ets as $et ){
            if($et->N_EXERCICE!=$nex){
                $compteur=1;
            }
            $compteur=sprintf("%08d", $compteur);
            $et->N_ECRITURE = $et->N_DOSSIER.$et->N_EXERCICE.$compteur;
            $et->DEBIT= $et->det->sum('DEBIT');
            $et->CREDIT= $et->det->sum('CREDIT');
            $et->COMPTAGE_LIGNE= $et->det->count();
            $compte=DB::select( DB::raw("SELECT count(DISTINCT N_CPTE_TIERS) as compte FROM bdd_trs_lanwest.comptabilit_det WHERE N_ECRITURE_FEC_IMPORT = '$et->N_ECRITURE_FEC_IMPORT' AND N_CPTE_TIERS!=''") );
            $et->COMPTAGE_TIERS= $compte[0]->compte;
            if($compte[0]->compte==1){
                $n_cpte_tiers=DB::select( DB::raw("SELECT  N_CPTE_TIERS as compte FROM bdd_trs_lanwest.comptabilit_det WHERE N_ECRITURE_FEC_IMPORT = '$et->N_ECRITURE_FEC_IMPORT' AND N_CPTE_TIERS!=''") );
                // dd($n_cpte_tiers);
                $et->N_CPTE_TIERS= $n_cpte_tiers[0]->compte;
            }
            $et->save();
            $dets=$et->det;
            foreach($dets as $det){
                $det->N_ECRITURE = $et->N_ECRITURE;
                $det->save();
            }
            $compteur++;
            $nex= $et->N_EXERCICE;
        }
    }
    /**
     *
     * @param  mixed $request
     * @return void
     */
    public function addDoc(request $request)
    {
        $path = $request->blabla->getRealPath();
        $logo = file_get_contents($path);
        $base64 = base64_encode($logo);
        Storage::disk('local')->put('file/newClient/' . $request->blabla->getClientOriginalName(), $logo);
    }    
    /**
     * mapFields
     *
     * @return array
     */
    public function mapFields()
    {
        $arr = [
            'JournalCode' => 'CODE_JOURNAL',
            'EcritureDate' => 'DATE',
            'ValidDate' => 'DATE_CLOTURE_EXERCICE',
            'JournalLib' => 'NOM_JOURNAL',
            'Debit' => 'DEBIT',
            'Credit' => 'CREDIT',
            'EcritureNum' => 'EcritureNum',
            'CompteNum' => 'N_CPTE_GENERAL',
            'PieceDate' => 'DATE_TRESO',
            'PieceRef' => 'N_PIECE',
            'EcritureLib' => 'LIBELLE',
            'EcritureLet' => 'LETTRAGE',
            'DateLet' => 'DATE_LETTRAGE',
        ];
        return $arr;
    }    
    /**
     * mapLettrage
     *
     * @return array
     */
    public function mapLettrage()
    {
        $arr = [
            'A' => 1,
            'B' => 2,
            'C' => 3,
            'D' => 4,
            'E' => 5,
            'F' => 6,
            'G' => 7,
            'H' => 8,
            'I' => 9,
            'J' => 10,
            'K' => 11,
            'L' => 12,
            'M' => 13,
            'N' => 14,
            'O' => 15,
            'P' => 16,
            'Q' => 17,
            'R' => 18,
            'S' => 19,
            'T' => 20,
            'U' => 21,
            'V' => 22,
            'W' => 23,
            'X' => 24,
            'Y' => 25,
            'Z' => 26,
        ];
        return $arr;
    }
}
