<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Task;

class TaskController extends Controller
{
    public function index()
    {
        // Rcuprer toutes les tches
        $tasks = Task::all();

        return response()->json($tasks);
    }

    public function store(Request $request)
    {
        // Valider les donnes entres
        $validatedData = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'status' => 'required|in:todo,inProgress,completed', // Valider le statut
        ]);

        // Crer une nouvelle tche
        $task = Task::create($validatedData);

        return response()->json($task, 201);
    }

    public function update(Request $request, Task $task)
    {
        $validatedData = $request->validate([
            'status' => 'required|in:todo,inProgress,completed',
        ]);

        // Mettre  jour le statut de la tche
        $task->update(['status' => $validatedData['status']]);

        return response()->json($task, 200);
    }


    public function moveTask(Request $request, Task $task)
    {
        // Valider la colonne cible (statut)
        $validatedData = $request->validate([
            'status' => 'required|in:todo,inProgress,completed',
        ]);

        // Mettre  jour le statut de la tche
        $task->update(['status' => $validatedData['status']]);

        return response()->json($task, 200);
    }
}
