<?php

namespace App\Http\Controllers\Tickets;

use App\Http\Controllers\Controller;
use App\Http\Controllers\InterfacesApi\jira\CreateIssue;
use App\Http\Controllers\InterfacesApi\notion\CreatePage;
use App\Http\Controllers\Utils\MultiDbController;
use App\Mail\TicketMail;
use App\Mail\TicketMailDate;
use App\Models\ST\support\Doc_archive_support;
use App\Models\ST\support\Support_det;
use App\Models\ST\support\Support_et;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;



class TicketsController extends Controller
{
    public function getTickets()
    {
        $liste_db = MultiDbController::getListeDbs();
        $tickets = [];
        foreach ($liste_db as $key => $db) {
            $support_et = new Support_et();
            $datas = $support_et->on($db)->where('CLOTURE', '=', '')->where('TYPE_TICKET', '!=', 'Refusé')->where('TYPE_TICKET', '!=', 'Clôturé')->where('TYPE_TICKET', '!=', 'En cours')->where('TYPE_TICKET', '!=', 'Evolution')->where('TRAITE_PAR', '')->orderBy('SYS_DATE_CREATION', 'DESC')->get();
            $NOM_DOSSIER = DB::connection($db)->table('aide_configuration_entreprise')->where('RAISON_SOCIALE', 'LIKE', '%' . $db . '%')->value('NOM_REP');
            foreach ($datas as $key => $et) {
                $et['MEMO_ADM'] = $this->convert_to_utf8_recursively($et['MEMO_ADM']);
                $et['MEMO_CLOTURE_SUPPORT'] = $this->convert_to_utf8_recursively($et['MEMO_CLOTURE_SUPPORT']);
                $et['USER_CREATION'] = DB::connection($db)->table('sys_users')->where('SYS_LOGIN', $et['SYS_USER_CREATION'])->value('SYS_NOM_UTILISATEUR');
                $et['NOM_DOSSIER'] = $NOM_DOSSIER;
            }
            if ($datas->count() > 0) {
                $tickets[$db] = $datas;
            }
        }
        return $tickets;
    }
    public function getTicketsAll()
    {
        $liste_db = MultiDbController::getListeDbs();
        $tickets = [];
        foreach ($liste_db as $key => $db) {
            $support_et = new Support_et();
            $datas = $support_et->on($db)->orderBy('SYS_DATE_CREATION', 'DESC')->get();
            $NOM_DOSSIER = DB::connection($db)->table('aide_configuration_entreprise')->where('RAISON_SOCIALE', 'LIKE', '%' . $db . '%')->value('NOM_REP');
            foreach ($datas as $key => $et) {
                $et['MEMO_ADM'] = $this->convert_to_utf8_recursively($et['MEMO_ADM']);
                $et['MEMO_CLOTURE_SUPPORT'] = $this->convert_to_utf8_recursively($et['MEMO_CLOTURE_SUPPORT']);
                $et['USER_CREATION'] = DB::connection($db)->table('sys_users')->where('SYS_LOGIN', $et['SYS_USER_CREATION'])->value('SYS_NOM_UTILISATEUR');
                $et['NOM_DOSSIER'] = $NOM_DOSSIER;
            }
            if ($datas->count() > 0) {
                $tickets[$db] = $datas;
            }
        }
        return $tickets;
    }
    public function getTicketsHome($name)
    {
        $liste_db = MultiDbController::getListeDbs();
        $tickets = [];
        foreach ($liste_db as $key => $db) {
            $support_et = new Support_et();
            $datas = $support_et->on($db)->where('CLOTURE', '=', '')->where('TYPE_TICKET', '!=', 'Refusé')->where('TYPE_TICKET', '!=', 'Clôturé')->where('TYPE_TICKET', '!=', 'Evolution')->where('TRAITE_PAR', '=', "$name")->orderBy('SYS_DATE_CREATION', 'DESC')->get();
            $NOM_DOSSIER = DB::connection($db)->table('aide_configuration_entreprise')->where('RAISON_SOCIALE', 'LIKE', '%' . $db . '%')->value('NOM_REP');
            foreach ($datas as $key => $et) {
                $et['MEMO_ADM'] = $this->convert_to_utf8_recursively($et['MEMO_ADM']);
                $et['MEMO_CLOTURE_SUPPORT'] = $this->convert_to_utf8_recursively($et['MEMO_CLOTURE_SUPPORT']);
                $et['USER_CREATION'] = DB::connection($db)->table('sys_users')->where('SYS_LOGIN', $et['SYS_USER_CREATION'])->value('SYS_NOM_UTILISATEUR');
                $et['NOM_DOSSIER'] = $NOM_DOSSIER;
            }
            if ($datas->count() > 0) {
                $tickets[$db] = $datas;
            }
        }
        return $tickets;
    }
    public function getTicket(request $request, $db, $id)
    {

        //recup de l'et et du det
        // $second=$support_et->on('colocauto')->where('CLOTURE', '=', '')->get();
        $et = Support_et::on($db)->find($id)->toArray();
        $det = Support_et::on($db)->find($id)->det;
        $datas = ['et' => $et, 'det' => $det];
        $datas['et']['MEMO_ADM'] = $this->convert_to_utf8_recursively($datas['et']['MEMO_ADM']);
        $datas['et']['MEMO_CLOTURE_SUPPORT'] = $this->convert_to_utf8_recursively($datas['et']['MEMO_CLOTURE_SUPPORT']);
        $datas['et']['USER_CREATION'] = DB::connection($db)->table('sys_users')->where('SYS_LOGIN', $et['SYS_USER_CREATION'])->value('SYS_NOM_UTILISATEUR');

        $datas['doc'] = DB::connection($db)->table('doc_archive_support')->where('PID_SUPPORT_ET', $id)->get();
        //AIDES SUPPORT
        $datas['et']['aide_support_prio'] = DB::connection('egp')->table('aide_support_prio')->get('PRIORITE');
        $datas['et']['aide_support_prio'] = array_map(function ($item) {
            return $item->PRIORITE;
        }, $datas['et']['aide_support_prio']->toArray());


        $datas['et']['aide_support_nature_pb'] = DB::connection('egp')->table('aide_support_nature_pb')->get('NATURE');
        $datas['et']['aide_support_nature_pb'] = array_map(function ($item) {
            return $item->NATURE;
        }, $datas['et']['aide_support_nature_pb']->toArray());

        $datas['et']['aide_support_type_prio'] = DB::connection('egp')->table('aide_support_type_prio')->get('PRIORITE');
        $datas['et']['aide_support_type_prio'] = array_map(function ($item) {
            return $item->PRIORITE;
        }, $datas['et']['aide_support_type_prio']->toArray());
        // $datas= $this->convert_to_utf8_recursively($datas);
        foreach ($datas['det'] as $key => $det) {
            $datas['det'][$key]['TEXT_TICKET'] = mb_convert_encoding($datas['det'][$key]['TEXT_TICKET'], 'UTF-8', 'ISO-8859-1');
            $datas['det'][$key]['REPONSE_TICKET'] = mb_convert_encoding($datas['det'][$key]['REPONSE_TICKET'], 'UTF-8', 'ISO-8859-1');
        }
        return ($datas);
    }
    public function postTicket(request $request, $db, $id)
    {
        //recup db depuis le referer
        //recup le ticket
        $et = Support_et::on($db)->find($id);
        $datas = $request->all();
        $et->fill($datas)->save();
    }
    public function postTicketDet(request $request, $db, $id)
    {
        //recup db depuis le referer
        //recup le ticket
        $det = Support_det::on($db)->orderBy('SYS_DATE_CREATION', 'DESC')->find($id);
        $et = $det->et;
        $detAll = $request->all();
        if ($detAll['CLOTURE'] == 1) {
            $et->TYPE_TICKET = 'Clôturé';
            $et->save();
        }
        // $datas['REPONSE_TICKET'] = $this->convert_to_utf8_recursively($datas['REPONSE_TICKET']);
        $detAll['REPONSE_TICKET'] = mb_convert_encoding($detAll['REPONSE_TICKET'], 'ISO-8859-1', 'UTF-8');
        $det->DATE_REP_SUPPORT = date('Y-m-d H:i:s');
        $det->fill($detAll)->save();

        $det['TEXT_TICKET'] = mb_convert_encoding($det['TEXT_TICKET'], 'UTF-8', 'ISO-8859-1');
        $det['REPONSE_TICKET'] = mb_convert_encoding($det['REPONSE_TICKET'], 'UTF-8', 'ISO-8859-1');
        $pjs= Doc_archive_support::on($db)->where('PID_SUPPORT_DET', $det->ID_SUPPORT_DET)->get();
        foreach($pjs as $key=>$pj){
            $nom = mb_convert_encoding($pj['DOC_SUPPORT_FICHIER_NOM'], 'UTF-8', 'ISO-8859-1');
            $doc=substr($pjs[$key]['DOC_SUPPORT_FICHIER_CONTENU'], strpos($pj['DOC_SUPPORT_FICHIER_CONTENU'], ',')+1 );
            Storage::disk('public')->put($nom, base64_decode($doc));
            $pj['url'] = env('BASEURL'); //acquire URL
            $pj['url'] .= "/storage/app/public/$nom"; //acquire URL
        }
        Mail::to($et['EMAIL'])->send(new TicketMail($et, $det, $pjs));
        return $det;
    }
    function convert_to_utf8_recursively($dat)
    {
        if (is_string($dat)) {
            return mb_convert_encoding($dat, 'UTF-8', 'UTF-8');
        } elseif (is_array($dat)) {
            $ret = [];
            foreach ($dat as $i => $d) {
                $ret[$i] = $this->convert_to_utf8_recursively($d);
            }
            return $ret;
        } else {
            return $dat;
        }
    }
    function sendNotifEscalade(request $request, $db, $id)
    {
        $datas = $request->all();
        $channel = 'slackTicket' . $datas['Tech'];
        Log::channel($channel)->info('Un ticket a été transféré par le support', [
            'name' => $datas['Tech'],
            'objet' => $datas['Objet'],
            'Texte' => $datas['Texte'],
            'Date' => $datas['Date'],
            'Lien' => $datas['Lien'],
        ]);
        if ($datas['Tech'] == 'Lucas') {
            // CreateIssue::createissueJira($datas);
            CreatePage::createPageNotion($datas);
        }
    }
    function sendNotifNewOrReponse($db, $id)
    {
        $et = Support_et::on($db)->find($id);
        if($et['TRAITE_PAR']==''){
            $channel = 'slackTicketNew';
            Log::channel($channel)->info('Un nouveau ticket vient d\'être créé : ', [
                'Objet' => $et['OBJET_TICKET'],
                'N_ticket' => $et['N_TICKET'],
                'Pour ' => $db,
            ]);    
        }else{
        $channel = 'slackTicket' . $et['TRAITE_PAR'];
        Log::channel($channel)->info('Une réponse client a été ajouté ', [
            'N°ticket' => $et['N_TICKET'],
            'objet' => $et['OBJET_TICKET']
        ]);
        // if ($et['TRAITE_PAR'] == 'Lucas') {
        //     // CreateIssue::createissueJira($datas);
        //     // CreatePage::createPageNotion($datas);
        // }}
    }
    
}
function sendMailDateEch(request $request, $db, $id)
    {
        $et = Support_et::on($db)->find($id);
        Mail::to($et['EMAIL'])->send(new ticketMailDate($et));
    }
    function addDocToTicket(request $request, $db, $id, $id_det)
    {
        // dd($request);
        $path = $request->blabla->getRealPath();
        $logo = file_get_contents($path);
        $base64 = base64_encode($logo);
        $src = 'data: ' . mime_content_type($path) . ';base64,' . $base64;
        $id_et = Str::random($length = 32);
        $det = Support_det::on($db)->find($id_det);
        // $det = Support_det::on($db)->find($id, 'PID_SUPPORT_ET');
        doc_archive_support::on($db)->create(['PID_SUPPORT_DET' => $det->ID_SUPPORT_DET,'ID_DOC_ARCHIVE_SUPPORT' => $id_et, 'DOC_SUPPORT_FICHIER_CONTENU' => $src, 'PID_SUPPORT_ET' => $id, 'DOC_SUPPORT_FICHIER_TYPE' => $request->blabla->extension(), 'DOC_SUPPORT_FICHIER_NOM' => $request->blabla->getClientOriginalName()]);
        $request->blabla->storeAs('lala', $request->blabla->getClientOriginalName());
        // dd($datas);die;
        // return $datas;
    }
    function delDocToTicket(request $request, $db, $id)
    {
        $datas = $request->all();
        doc_archive_support::on($db)->where('ID_DOC_ARCHIVE_SUPPORT', $datas['ID_DOC_ARCHIVE_SUPPORT'])->delete();
        // dd($datas);die;
        // return $datas;
    }
    function postTicketDetReouverture(request $request, $db, $id)
    {
        $det_modl = Support_det::on($db)->find($id);
        $det = new Support_det;
        $det->setConnection($db);
        $det->ID_SUPPORT_DET = Str::random($length = 32);
        $det->PID_SUPPORT_ET = $det_modl->PID_SUPPORT_ET;
        $det->DATE_TICKET_DET = date('Y-m-d H:i:s');
        $det->SYS_USER_CREATION = 'ADM';
        $det->save();
        return $det;
    }
}