<?php

namespace App\Http\Middleware;

use App\Models\User;
use App\Services\ApiLogManager;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ClientsExternes
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // pour ces clients la methode d'envoie des tokens est différente.
        if(($request->header('Auth') == env('API_KEY_PDL')
                ||$request->header('Auth') == env('API_KEY_COUE')
                || $request->header('Auth') == env('API_KEY_EGP')
                || $request->header('Auth') == env('API_KEY_TAROT')
                || $request->header('Auth') == env('API_KEY_PMGP')
                || $request->header('Auth') == env('API_KEY_TRM')
                || $request->header('Auth') == env('API_KEY_MORIN')
                || $request->header('Auth') == env('API_KEY_LANWEST')
                || $request->header('Auth') == env('API_KEY_PJP')
                || $request->header('Auth') == env('API_KEY_LIMOUSIN')
                || $request->header('Auth') == env('API_KEY_MDL')  )
            && $this::CheckDbRights($request->header('Auth'), $request->path())  ){

            (new ApiLogManager())
                ->log(
                    "success",
                    "API-CLIENT-EXTERNE",
                    now()->format("Y-m-d H:i:s"),
                    now()->format("Y-m-d H:i:s"),
                    0,
                    0,
                    [
                        'token' => Str::substr($request->header('Auth'), 0,3),
                        'authorized' => true
                    ],
                );
            return $next($request);  // On continue
        }
        else {

            /*
                PMIL 02/10/2024 - Si Bearer token est introuvable, pas la peine de continuer !
            */

            if(ClientsExternes::getBearerToken($request) == null) {
                abort(response('Wrong auth.', 401));
            }
            $token=ClientsExternes::getBearerToken($request);

            if($token == env('API_KEY_PDL')){
                if( $this::CheckDbRights($token, $request->path())) {
                    (new ApiLogManager())
                        ->log(
                            "success",
                            "API-CLIENT-EXTERNE",
                            now()->format("Y-m-d H:i:s"),
                            now()->format("Y-m-d H:i:s"),
                            0,
                            0,
                            [
                                'token' => Str::substr($token, 0,3),
                                'authorized' => true
                            ],
                        );
                    return $next($request);
                }
            }

            (new ApiLogManager())
                ->log(
                    "failure",
                    "API-CLIENT-EXTERNE",
                    now()->format("Y-m-d H:i:s"),
                    now()->format("Y-m-d H:i:s"),
                    0,
                    0,
                    [
                        'token' => Str::substr($request->header('Auth'), 0,3),
                        'authorized' => false
                    ],
                );

            abort(response('Wrong auth.', 401));
        }
    }
    static function getBearerToken($request){
        $header = $request->header('Authorization');
        if (Str::startsWith($header, 'Bearer '))
        {
            return Str::substr($header, 7);
        }
        return null;
    }
    static function CheckDbRights($auth, $database)
    {
        if (strpos($database,substr($auth,0,3) )===false) {

            (new ApiLogManager())
                ->log(
                    "failure",
                    "API-CLIENT-EXTERNE",
                    now()->format("Y-m-d H:i:s"),
                    now()->format("Y-m-d H:i:s"),
                    0,
                    0,
                    [
                        'token' => Str::substr($auth, 0,3),
                        'authorized' => false,
                        'database' => strpos($database,substr($auth,0,3) ),
                    ],
                );

            abort(response('You are authentificated, but do not have access to that db.', 401));
        }else{

            return true;
        }
    }
}
