<?php

namespace App\Imports;

use App\Models\TiersInfosSaliariesTemp;
use Maatwebsite\Excel\Concerns\ToModel;

/*
 *
 * Example du contenu du csv :

    80;4c6e5364bd585edac706605db520c9ac;CP;20240910;M;20240910;A;C
    1;113031b07deedb51458542cc872f59d4;CP;20240911;M;20240911;A;C
    425;a87f04da4d68e9cb70cb07639a3dd4d9;CP;20240912;M;20240912;A;C
    1AAAB01;e3943bc6ef3b148d879be97977093135;CP;20240909;M;20240909;A;C

 */

class TiersInfosSaliariesImport implements ToModel
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        return new TiersInfosSaliariesTemp([
            /*

                    80;   => Matricule de paie
                    4c6e5364bd585edac706605db520c9ac; => ID_TIERS_INFOS_SALARIES
                    CP; => Code évènement
                    20240910; => Date de début
                    M; => Demi journée de début  (M ou A) cad 8H ou 13H)
                    20240910; => Date de fin
                    A; => Demi journée de fin
                    C => Type C (créer) ou S (supprimer)
            */
            'matricule_de_paie' => $row[0],
            'pid_tiers' => $row[1],
            'code_evenement' => $row[2],
            'date_de_debut' => $row[3],
            'demi_journee_de_debut' => $row[4],
            'date_de_fin' => $row[5],
            'demi_journee_de_fin' => $row[6],
            'type' => $row[7],
            'controle' => $row[0].$row[1].$row[2].$row[3].$row[4].$row[5].$row[6].$row[7],
        ]);
    }
}
