<?php

namespace App\Services;

/*
 * Ce service est là pour appliquer les logiques necessaire a la gestion des import des données sociales.
 */

use App\Models\ST\auto\action_interne;
use App\Models\ST\auto\aide_action_sts;
use App\Models\ST\auto\tiers;
use App\Models\ST\auto\tiers_infos_salaries;
use App\Models\TiersInfosSaliariesTemp;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Ramsey\Uuid\Uuid;
use Spatie\Emoji\Emoji;

class RhImportService
{

    protected $tiers;
    protected $action_sts;
    protected $csv_line;

    public function __construct(null|TiersInfosSaliariesTemp $csv_line)
    {
        if($csv_line) {
            $this->csv_line = $csv_line;

            $this->tiers = tiers::query()
                ->where('ID_TIERS',$csv_line->pid_tiers)
                ->where('COMPTE_ACTF','X')
                ->first();
            if(!$this->tiers)dd($this->csv_line);

            $this->action_sts = aide_action_sts::query()
                ->where('CODE_ACTION',$csv_line->code_evenement)
                ->get()
                ->first();

        }
    }

    public function archiveCsvRhInfosFile(string $filename): string
    {
        // Check existance of archive structure directory on disk 'sts_rh_import_archive'
        $year = now()->format('Y');
        $month= now()->format('m');
        $day = now()->format('d');

        if(!Storage::disk('sts_rh_import_archive')->exists('/'.$year)) {
            Storage::disk('sts_rh_import_archive')->makeDirectory('/'.$year);
        }

        if(!Storage::disk('sts_rh_import_archive')->exists('/'.$year.'/'.$month)) {
            Storage::disk('sts_rh_import_archive')->makeDirectory('/'.$year.'/'.$month);
        }

        if(!Storage::disk('sts_rh_import_archive')->exists("/".$year.'/'.$month.'/'.$day)){
            Storage::makeDirectory("/".$year.'/'.$month.'/'.$day);
        }


        // copy file to archive YEAR/MONTH/DAY
        Storage::disk('sts_rh_import_archive')->put(
            "/".$year.'/'.$month.'/'.$day."/".$filename,
            Storage::disk('sts_rh_import')->get($filename)
        );

        if(Storage::disk('sts_rh_import_archive')
            ->exists("/".$year.'/'.$month.'/'.$day."/".$filename))
        {
            Storage::disk('sts_rh_import')->delete($filename);
            return Emoji::checkMark()." OUI";
        }
        else {
            return Emoji::crossMark();
        }
        //cleanup original source file
    }


    /*
     * Supprimer un event consite a marquer dans le champ SUP le fait qu'il est supprimé.
     * Mettre à jour la date de modification. afin d'identifier le bon enregistrement on
     *  utilise aussi le champ de controle au niveau de la table action interne.
     *
     */
    public function deleteRhEvent(): string
    {

        $recherche_action = action_interne::query()
            ->where('CONTROLE', $this->csv_line->controle)
            ->first();

        if($recherche_action){
            $recherche_action->SUP = TRUE;
            $recherche_action->SYS_DATE_MODIFICATION = now()->Format('Y-m-d');
            $recherche_action->SYS_HEURE_MODIFICATION = now()->Format('H:i');
            $recherche_action->save();
        }

        return '['.$this->csv_line->type . ']--> () SUP RH event ' . $this->csv_line->controle." ".  $this->action_sts->NOM_ACTION ." pour " . $this->tiers->NOM . " " .$this->tiers->PRENOM.PHP_EOL;;
    }

    /*
     * Création d'un enregistrement dans la table action_type.
     * pour retrouver les infos on se fie a PID_tiers dans la table Tiers (reference principale ID_TIERS)
     * Attention cependant, dans la table tiers_infos_salaries, le tiers peut avoir deux dossiers, il daut prendre le plus récent
     *
     */
    public function createRhEvent(): string
    {

        $id_action_interne = substr(Uuid::uuid4(), 0 , 32);
        $tier_infos_salarie = tiers_infos_salaries::query()
            ->where('PID_TIERS',$this->csv_line->pid_tiers)
            ->whereNull('DATE_SORTIE')
            ->orderBy('DATE_ENTREE')
            ->first();

        if(!$tier_infos_salarie) {
            dump($this->csv_line->toArray());
            dump("id_action_interne :" .$id_action_interne);
            dump('tiers_infos_salaries est introuvable !');
            'ERROR  |==> ' . $this->action_sts->NOM_ACTION ." pour " . $this->tiers->NOM . " " .$this->tiers->PRENOM . " tiers_infos_salaries est introuvable !".PHP_EOL;
        }

        $nom_dossier = $tier_infos_salarie->NOM_DOSSIER;
        $n_dossier = $tier_infos_salarie->N_DOSSIER;
        $pid_tiers_infos_salaries = $tier_infos_salarie->ID_TIERS_INFOS_SALARIES;
        $raison_social = $tier_infos_salarie->NOM_SALRIE ?? '';
        $type_evenement = "Evènement";
        $prise_rdvs = "OK";
        $memo = "Importé depuis STS le ".now()->format('Y-m-d H:i:s');




// = concat des lignes de l’import sauf de la
//dernière colonne
        $concat = "";

        $type_action = aide_action_sts::query()
            ->where('CODE_ACTION', $this->csv_line->code_evenement)
            ->first();



                action_interne::create(
                    [
                        'CONTROLE'=> $this->csv_line->controle,
                        'A_FAIRE_PAR' => $this->tiers->NOM . " " .$this->tiers->PRENOM,
                        'DATE_DEBUT' => null,  // nullable
                        'DATE_FIN' => null, // nullable
                        //'FAIT' => 'X',
                        'FAMILLE' => '',
                        'FIMO' => '',
                        'HEURE_DEBUT' => '00:00:00',
                        'HEURE_FIN' => '00:00:00',
                        'ID_ACTION_INTERNE' => $id_action_interne,
                        'MEMO' => null,  // blob nullable
                        'NOMBRE' => 0, // ou 1 ??? ca veut dire quoi ?
                        'NOM_DOSSIER' => $nom_dossier,
                        'N_DOSSIER' => $n_dossier,  // default 0
                        'PID_TIERS' => $this->csv_line->pid_tiers,
                        'PID_TIERS_INFOS_SALARIES' => $pid_tiers_infos_salaries,
                        'RAISON_SOCIALE' => $raison_social,
//                        'SYS_DATE_CREATION' => now()->format('Y-m-d'), // nullable
//                        'SYS_DATE_MODIFICATION' => now()->format('Y-m-d'), // nullable
//                        'SYS_HEURE_CREATION' => now()->format('H:i:s'),
//                        'SYS_HEURE_MODIFICATION' => now()->format('H:i:s'),
                        'SYS_USER_CREATION' => now()->format('Y-m-d'),
                        'SYS_USER_MODIFICATION' => now()->format('Y-m-d'),
                        'TYPE_ACTION' => $type_action->NOM_ACTION,  // Visite Attestation de Permis
                        'TYPE_EVENEMENT' => $type_evenement, // Evénement  ou Tâche
                        'VISITE_APTH' => null,
                        'VM_DATE_VALIDITE' => null,
                       // 'VM_ENTRETIEN_INFIRMIER' => null,
                        //'VM_ENTRETIEN_MEDECI' => null,
                        'ABS_NR' => 0,
                        'ABS_REM' => 0,
                        'DATE_HEURE' => 0,
                        'HEURE_CONDUITE' => 0,
                        'HEURE_CONGES_PAYES' => 0,
                        'HEURE_DELEGATION' => 0,
                        'HEURE_DIPSO_DE' => 0,
                        'HEURE_DISPO_SOLO' => 0,
                        'HEURE_FORMATION' => 0,
                        'HEURE_JOURS_FERIES' => 0,
                        'HEURE_MALADIE' => 0,
                        'HEURE_NUIT' => 0,
                        'HEURE_REPOS_COMPENSATEUR' => 0,
                        'HEURE_SERVICE' => 0,
                        'HEURE_TRAVAIL' => 0.00,
                        'KM' => 0,
                       // 'LIEU_VISITE_MEDICALE' => null, // non nullable ???
                        //'MEDECIN' => null,  // non nullable ???
                        'N_DEJ' => 0,
                        'N_DEJ_INTER' => 0,
                        'N_DEPART_DIMANCHE' => 0,
                        'N_DEPART_FERIE' => 0,
                        'N_DIN' => 0,
                        'N_DIN_INTER' => 0,
                        'N_DIVERS' => 0,
                        'N_IMPORT' => 0,
                        'N_NUIT' => 0,
                        'N_NUIT_INTER' => 0,
                        'N_PDJ' => 0,
                        //'N_PDJ_INTER' => null,
//                        'N_SAMEDI_APRES_18_LUNDI_MATIN' => null,
//                        'N_SAMEDI_MATIN_LUNDI_MATIN' => null,
//                        'N_TRAVAIL_JOUR_FERIE_COMPLET' => null,
//                        'N_UNI' => null,
//                        'N_UNI_INTER' => null,
//                        'N_VENDREDI_19_SAMEDI_APRES_19' => null,
//                        'N_VENDREDI_SOIR_LUNDI_MATIN' => null,
//                        'PID_TIERS_INFO_PAIE' => null,  // non null
//                        'SERVICE_ASSIMILE' => null,
//                        'T_DEJ' => null,
//                        'T_DEJ_INTER' => null,
//                        'T_DEPART_DIMANCHE' => null,
//                        'T_DEPART_FERIE' => null,
//                        'T_DIN' => null,
//                        'T_DIN_INTER' => null,
//                        'T_DIVERS' => null,
//                        'T_NUIT' => null,
//                        'T_NUIT_INTER' => null,
//                        'T_PDJ' => null,
//                        'T_PDJ_INTER' => null,
//                        'T_SAMEDI_APRES_18_LUNDI_MATIN' => null,
//                        'T_SAMEDI_MATIN_LUNDI_MATIN' => null,
//                        'T_TRAVAIL_JOUR_FERIE_COMPLET' => null,
//                        'T_UNI' => null,
//                        'T_UNI_INTER' => null,
//                        'T_VENDREDI_19_SAMEDI_APRES_19' => null,
//                        'T_VENDREDI_SOIR_LUNDI_MATIN' => null,
//                        'VITESSE_MOYENNE' => null,
//                        'HEURE_SERV' => null,
//                        'JOUR_FERIE' => null,
//                        'MATRICULE' => null,
//                        'HEURE_ACCIDENT' => null,
//                        'TEMPS_ALERTE' => null,
//                        'FREQUENCE' => null,
//                        'HEURE_JOUR' => null,
                        //'HEURE_AMPLITUDE' => null,
                        //'HEURE_INTEGRATION' => null,
//                        'N_DEPART_DIMANCHE_WE' => null,
//                        'N_DIVERS_INTER' => null,
//                        'N_TICKET_RESTAU' => null,
//                        'T_DEPART_DIMANCHE_WE' => null,
//                        'T_DIVERS_INTER' => null,
//                        'T_TICKET_RESTAU' => null,
//                        'RH_ATTRIBUE' => null,
//                        'DATE_ALERTE' => null,
//                        'CODE_JOUR' => null,
//                        'SUP' => null,

                    ]
                );

        /*
            public function delRhEvent(TiersInfosSaliariesTemp $csv_line){
                /*[
                    'matricule_de_paie',
                    'pid_tiers',
                    'code_evenement',
                    'date_de_debut',
                    'demi_journee_de_debut',
                    'date_de_fin',
                    'demi_journee_de_fin',
                    'type',
                    'controle'
                ]*/
      return '  |++> ' . $this->action_sts->NOM_ACTION ." pour " . $this->tiers->NOM . " " .$this->tiers->PRENOM.PHP_EOL;
    }

}
